package gov.cms.grouper.snf.component.v100.logic.nursing;

import static gov.cms.grouper.snf.component.v100.TestUtil.of;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import gov.cms.grouper.snf.model.Assessment;
import gov.cms.grouper.snf.model.enums.NursingCmg;
import gov.cms.grouper.snf.util.ClaimInfo;

public class ReducedPhysicalFunctionLogicTest {

  public static NursingCmg makeExecStep3(int functionScore, int restorativeNursingCount) {
    ClaimInfo claim = of(functionScore);
    BscpLogic bscp = null;
    ReducedPhysicalFunctionLogic logic = new ReducedPhysicalFunctionLogic(claim, bscp);

    NursingCmg result = logic.step3(restorativeNursingCount);
    return result;
  }

  @Test
  public void testStep3() {
    NursingCmg expected = NursingCmg.PDE2;
    NursingCmg actual = makeExecStep3(0, 2);
    Assertions.assertEquals(expected, actual);

    expected = NursingCmg.PDE2;
    actual = makeExecStep3(5, 10);
    Assertions.assertEquals(expected, actual);

    expected = NursingCmg.PDE1;
    actual = makeExecStep3(0, 0);
    Assertions.assertEquals(expected, actual);

    expected = NursingCmg.PDE1;
    actual = makeExecStep3(5, 1);
    Assertions.assertEquals(expected, actual);

    expected = NursingCmg.PBC2;
    actual = makeExecStep3(6, 2);
    Assertions.assertEquals(expected, actual);

    expected = NursingCmg.PBC2;
    actual = makeExecStep3(14, 9);
    Assertions.assertEquals(expected, actual);

    expected = NursingCmg.PA2;
    actual = makeExecStep3(15, 2);
    Assertions.assertEquals(expected, actual);

    expected = NursingCmg.PA2;
    actual = makeExecStep3(16, 9);
    Assertions.assertEquals(expected, actual);

    expected = NursingCmg.PBC1;
    actual = makeExecStep3(6, 0);
    Assertions.assertEquals(expected, actual);

    expected = NursingCmg.PBC1;
    actual = makeExecStep3(14, 1);
    Assertions.assertEquals(expected, actual);

    expected = NursingCmg.PA1;
    actual = makeExecStep3(15, 0);
    Assertions.assertEquals(expected, actual);

    expected = NursingCmg.PA1;
    actual = makeExecStep3(16, 1);
    Assertions.assertEquals(expected, actual);

    expected = null;
    actual = makeExecStep3(17, 1);
    Assertions.assertEquals(expected, actual);

    expected = null;
    actual = makeExecStep3(-1, 1);
    Assertions.assertEquals(expected, actual);

    expected = null;
    actual = makeExecStep3(6, -1);
    Assertions.assertEquals(expected, actual);

  }


  @Test
  public void testExec() {
    List<Assessment> assessments = Arrays.asList(new Assessment("GG0170B1", "GG0170B1", 7));
    ClaimInfo claim = of(assessments);
    int functionScore = claim.getFunctionScore();
    BscpLogic bscp = BscpLogicTest.make(100, claim, null);
    ReducedPhysicalFunctionLogic logic = new ReducedPhysicalFunctionLogic(claim, bscp);

    String actual = logic.exec().name();
    String expected = "PDE1";
    Assertions.assertEquals(expected, actual);

    Integer functionScoreActual = functionScore;
    Integer functionScoreExpected = 0;
    Assertions.assertEquals(functionScoreExpected, functionScoreActual);
  }

}
